"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
// src/middleware/validate.js
var _require = require("zod"),
  ZodError = _require.ZodError;
var validateMiddleware = function validateMiddleware() {
  var schemas = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return function (req, res, next) {
    try {
      if (schemas.body) req.body = schemas.body.parse(req.body);
      if (schemas.params) req.params = schemas.params.parse(req.params);
      if (schemas.query) req.query = schemas.query.parse(req.query);
      next();
    } catch (err) {
      if (err instanceof ZodError) {
        // return res.status(400).reply().json({
        //   message: "Input data tidak valid",
        //   errors: JSON.parse(err).map(e => ({
        //     path: e.path.join("."),
        //     message: e.message
        //   }))
        // });
        return res.status(400).error("Terjadi kesalahan pada server", "Terjadi kesalahan pada server saat validasi", 400, JSON.parse(err).map(function (e) {
          return {
            path: e.path.join("."),
            message: e.message
          };
        }));
      }
      return res.status(500).error("Terjadi kesalahan pada server", "Terjadi kesalahan pada server saat validasi", 500);
    }
  };
};
var _default = exports["default"] = validateMiddleware;