"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Response = Response;
var _express = _interopRequireDefault(require("express"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function Response() {
  _express["default"].response.reply = function (data) {
    var title = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var message = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var code = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 200;
    var success = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
    this.json({
      meta: {
        success: success,
        code: code,
        title: title || "OK",
        message: message,
        errors: null
      },
      data: (Array.isArray(data) ? {
        items: data
      } : data) || null
    });
  };
  _express["default"].response.error = function () {
    var title = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Internal Server Error';
    var message = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "-";
    var status = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 500;
    var errors = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    this.status(status).json({
      meta: {
        success: false,
        code: status,
        title: title,
        message: message,
        errors: errors
      },
      data: null
    });
  };
}