"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _bcrypt = _interopRequireDefault(require("./bcrypt.adapter"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
var algorithm = process.env.ENCRYPTION_DRIVER || "bcrypt";
var adapters = {
  bcrypt: _bcrypt["default"]
  // argon2: Argon2Adapter,
};
var EncryptionDriver = adapters[algorithm];
if (!EncryptionDriver) {
  throw new Error("Encryption adapter \"".concat(algorithm, "\" tidak ditemukan"));
}
var _default = exports["default"] = EncryptionDriver;