"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _auth = _interopRequireDefault(require("../../app/controllers/auth.controller"));
var _jwt = _interopRequireDefault(require("../../app/middlewares/jwt.middleware"));
var _validate = _interopRequireDefault(require("../../app/middlewares/validate.middleware"));
var _login = _interopRequireDefault(require("../../app/rules/login.rule"));
var _register = _interopRequireDefault(require("../../app/rules/register.rule"));
var _express = require("express");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
var controller = new _auth["default"]();
var AuthRouter = (0, _express.Router)();
AuthRouter.use((0, _jwt["default"])({
  skip: [{
    url: '/sign-in',
    methods: ['POST', 'GET']
  }, {
    url: '/sign-up',
    methods: ['POST', 'GET']
  }, {
    url: '/sso',
    methods: ['GET']
  }]
}));
AuthRouter.post("/sign-in", (0, _validate["default"])(_login["default"]), controller.signIn);
AuthRouter.post("/sign-up", (0, _validate["default"])(_register["default"]), controller.signUp);
AuthRouter.get("/sso", controller.signInSSO);
AuthRouter.get("/me", controller.me);
var _default = exports["default"] = AuthRouter;