"use strict";

var _dotenv = _interopRequireDefault(require("dotenv"));
var _cors = _interopRequireDefault(require("cors"));
var _express = _interopRequireDefault(require("express"));
var _ = _interopRequireDefault(require("./error/500"));
var _2 = _interopRequireDefault(require("./error/404"));
var _response = require("./config/response");
var _routes = _interopRequireDefault(require("./routes"));
var _path = _interopRequireDefault(require("path"));
var _fs = _interopRequireDefault(require("fs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
_dotenv["default"].config();
var app = (0, _express["default"])();
var port = process.env.APP_PORT || 3000;
(0, _response.Response)();
app.use((0, _cors["default"])({
  origin: "*",
  methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
  allowedHeaders: ['Content-Type', 'Authorization']
}));
app.use((0, _cors["default"])());
app.use(_express["default"].json());
app.get("/logs/:file_name", function (req, res) {
  res.setHeader("Content-Type", "text/plain");
  var fileName = req.params.file_name;
  var logPath = _path["default"].join(process.cwd(), "src/storage/logs", fileName);
  var stream = _fs["default"].createReadStream(logPath, "utf8");
  stream.pipe(res);
  stream.on("error", function (err) {
    throw err;
  });
});
try {
  app.use(_routes["default"]);
} catch (err) {
  throw err;
}
app.use(_2["default"]);
app.use(_["default"]);
app.listen(port, function () {
  console.log("Start application on port :" + port);
});