"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _winston = _interopRequireDefault(require("winston"));
var _path = _interopRequireDefault(require("path"));
var _fs = _interopRequireDefault(require("fs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
var logsDir = _path["default"].resolve("src/storage/logs");
if (!_fs["default"].existsSync(logsDir)) {
  _fs["default"].mkdirSync(logsDir, {
    recursive: true
  });
}
var logFilePath = _path["default"].join(logsDir, "APP_".concat((0, _moment["default"])().format("DD_MM_YYYY"), ".log"));
var logger = _winston["default"].createLogger({
  level: "info",
  format: _winston["default"].format.combine(_winston["default"].format.timestamp({
    format: "YYYY-MM-DD HH:mm:ss"
  }), _winston["default"].format.printf(function (_ref) {
    var timestamp = _ref.timestamp,
      level = _ref.level,
      message = _ref.message;
    return "[".concat(timestamp, "] ").concat(level.toUpperCase(), ": ").concat(message);
  })),
  transports: [
  // new winston.transports.Console(),
  new _winston["default"].transports.File({
    filename: logFilePath
  })]
});
var _default = exports["default"] = logger;